/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.IVWSplashWindowListener;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class VWLoadingWindow
extends JDialog
implements Runnable {
    private IVWSplashWindowListener m_listener = null;
    private int m_nSleepTimeInMilliseconds = 0;
    private Thread m_workerThread = null;
    private JLabel m_message = null;

    public VWLoadingWindow(Frame owner, String title) {
        super(owner, title);
        this.createControls();
    }

    public void start(IVWSplashWindowListener listener, int nSplashTimeInMilliseconds) {
        this.show();
        this.m_listener = listener;
        this.m_nSleepTimeInMilliseconds = nSplashTimeInMilliseconds;
        this.m_workerThread = new Thread((Runnable)this, "VWLoadingWindow");
        this.m_workerThread.start();
        Thread.yield();
    }

    public void run() {
        try {
            if (this.m_listener != null) {
                this.m_listener.startProcessing();
            }
            Thread.sleep(this.m_nSleepTimeInMilliseconds);
        }
        catch (InterruptedException ie) {
        }
        catch (Exception e) {
            VWDebug.logException(e);
        }
        this.setVisible(false);
        this.dispose();
    }

    private void createControls() {
        try {
            Dimension dim = VWStringUtils.stringToDimension("335,165");
            if (dim == null) {
                dim = new Dimension(300, 150);
            }
            this.setSize(dim);
            this.getContentPane().setLayout(new BorderLayout(10, 10));
            this.m_message = new JLabel(VWResource.s_loadingMessage);
            this.m_message.setHorizontalAlignment(0);
            this.getContentPane().add((Component)this.m_message, "Center");
            Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((screenDim.width - dim.width) / 2, (screenDim.height - dim.height) / 2);
            this.show();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

